	%	 Ex 12.14
	close all, clear all, clc
	N = 28; M = 0; Nband = 5;
	Be =[0 0.16 0.2 0.34 0.38 0.52 0.56 0.76 0.8 1]*pi; 	% Band edges
	PhaseDiff = [0, -1, -2, -1, 0]*pi;						% Phase differences
	W = [1, 30, 1, 30, 1];  disp(['Optimizing!'])
	[Z1, P1, Z2, P2, Att] = SYM_WDF(N, M, Nband, Be, PhaseDiff, W); 
	wT = linspace(0, pi, 1000);
	Sden1 = poly(P1);	  Sden2 = poly(P2);	 
	Sigma = 1; 									% According to Table 8.5
	S1 = -Sigma*freqz(fliplr(Sden1), Sden1,wT); 
	S2 = freqz(fliplr(Sden2), Sden2,wT);
	H  = 0.5*(S2-S1);
	figure(1); subplot(2,1,1)
	PLOT_MAG_Z_dB(wT, H, pi, 80, 'H')
	figure(2); subplot(2,1,1)
	PLOT_PZ_Z(Z1,P1)
	figure(3), subplot(2,1,1)
	PLOT_PZ_Z(Z2,P2)		
	figure(4);subplot(2,1,1), Npi = -14;
	PLOT_PHASE_Z2(wT,unwrap(angle(-S1)), Npi), hold on
	PLOT_PHASE_Z2(wT,unwrap(angle(S2)), Npi)
	for n = 1:Nband		
		fprintf('%1.0f. band  %2.12f dB \n',n,Att(n));	
	end

